/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.problem.history;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.persist.PersistentData;
import java.util.Date;
import org.w3c.dom.Node;

public class HistoryEntry
implements PersistentData,
Comparable,
XMLEncodeable {
    private Date date;
    private int history;
    private static final long serialVersionUID = 1L;

    public HistoryEntry() {
    }

    public HistoryEntry(int history) {
        this.setHistory(history);
    }

    public void toXML(StringBuffer sb) {
        sb.append("<history-entry class=\"" + this.getClass().getName() + "\"".concat(" value=\"").concat(Integer.toString(this.history)).concat("\" date=\"").concat(this.date.toString()).concat("\"/>"));
    }

    public void fromXML(Node node) {
        Node workNode = XMLHelper.getWorkSection(node, "history-entry");
        this.setHistory(Integer.parseInt(XMLHelper.getAttributeValue(workNode, "value")));
        this.date = XMLHelper.convertToDate(XMLHelper.getAttributeValue(workNode, "date"));
    }

    public int compareTo(Object o) {
        if (!(o instanceof HistoryEntry)) {
            throw new ClassCastException("All entries must be HistoryEntry's in this list");
        }
        HistoryEntry that = (HistoryEntry)o;
        return (int)(that.date.getTime() - this.date.getTime());
    }

    public Date getDate() {
        return this.date;
    }

    public int getHistory() {
        return this.history;
    }

    public void setHistory(int history) {
        this.setHistory(history, new Date());
    }

    public void setHistory(int history, Date date) {
        this.history = history;
        this.date = date;
    }
}

